//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Diagnostics;

using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;
using System.Runtime.Remoting.Channels.Tcp;

namespace CLRUnleashed.Remoting
{
	public class RemotingTest : MarshalByRefObject
	{
		private double DoTest(TimeObject timeService, int iterations)
		{
			string result;
			DateTime start = DateTime.Now;
			for(int i = 0; i < iterations; i++)
			{
				result = timeService.Time;
			}
			DateTime stop = DateTime.Now;
			TimeSpan elapsed = stop - start;
			return ((double)iterations/(double)elapsed.TotalMilliseconds) * 1000.0;
		}
		public double Test(string path, int iterations)
		{
			Debug.WriteLine(string.Format("Test: {0} {1}", path, iterations));
			if (path == null) 
			{
				throw new ArgumentNullException("Puste powitanie!");
			}
			Debug.WriteLine(string.Format("Uycie pliku konfiguracyjnego - {0}", path));
			RemotingConfiguration.Configure(path);
			TimeObject timeService = new TimeObject();
			double result = 0;
			if (true == RemotingServices.IsTransparentProxy(timeService))
			{
				Debug.WriteLine("Test: TimeObject zosta aktywowany na serwerze");
				result = DoTest(timeService, iterations);
			}
			return result;
		}
	}
}
